<?php

use App\Http\Controllers\Admin\ItemMasterController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('admin.items.index');
})->name('dashboard');

Route::prefix('admin')->name('admin.')->middleware('auth')->group(function () {
    Route::get('/item-master', [ItemMasterController::class, 'index'])->name('items.index');

    Route::get('/', function () {
        return redirect()->route('admin.items.index');
    })->name('dashboard');

    Route::post('/item-master/export', [ItemMasterController::class, 'replaceItemMaster'])->name('items.export');

    Route::get('/profile/change-password', [ProfileController::class, 'editPassword'])->name('profile.change-password');
    Route::post('/profile/change-password', [ProfileController::class, 'updatePassword'])->name('profile.update-password');

});

require __DIR__.'/auth.php';
