<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->longText('profile_picture')->nullable()->after('country');
            $table->boolean('hide_leave_balance')->default(false)->after('profile_picture');
            $table->boolean('new_design_for_leave_balance')->default(false)->after('hide_leave_balance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn('profile_picture');
            $table->dropColumn('hide_leave_balance');
            $table->dropColumn('new_design_for_leave_balance');
        });
    }
};
